using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.Odbc;

public partial class Podsumowanie : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Error += Blad; //prymitywna obsluga bledow

        if (Session["osoba"] == null) Response.Redirect("Formularz.aspx");

        if (Session["modyfikowanieDanych"] != null && (bool)Session["modyfikowanieDanych"]) Button2.Text = "Aktualizuj dane";

        StrukturyDanych.Osoba osoba = (StrukturyDanych.Osoba)Session["osoba"];
        Label1.Text = "Imi i Nazwisko: <FONT COLOR='navy'>" + osoba.Imie + " " + osoba.Nazwisko + "</FONT><BR>";
        Label1.Text += "Adres e-mail: <FONT COLOR='navy'>" + osoba.Email + "</FONT><BR>";
        Label1.Text += "Instytucja: <FONT COLOR='navy'>" + osoba.InstytucjaNazwa + "</FONT><BR>";

        StrukturyDanych.Nocleg nocleg = (StrukturyDanych.Nocleg)Session["nocleg"];
        if (nocleg.CzyNocleg)
        {
            int liczbaNocy = nocleg.Wyjazd - nocleg.Przyjazd;
            if (liczbaNocy > 0)
                Label1.Text += "<P>Noclegi: " + liczbaNocy.ToString() + " doby, <FONT COLOR='navy'>" + nocleg.TypPokoju + ", od " + nocleg.Przyjazd.ToString() + " lipca do " + nocleg.Wyjazd.ToString() + " lipca" + (nocleg.OsobaTowarzyszaca?", z osob towarzyszc":"") + "</FONT><BR>";
            else
                Label1.Text += "<P>Wyjazd w dniu przyjazdu, hotel nie zostanie zarezerwowany<BR>";
        }
        else Label1.Text += "<P>Bez noclegw<BR>";

        Label1.Text += "Wyywienie: <FONT COLOR='navy'>"+(nocleg.CzyWyzywienie?"tak":"nie") + "</FONT><BR>";

        if (osoba.CzyWyklad)
        {
            StrukturyDanych.Wyklad wyklad = (StrukturyDanych.Wyklad)Session["wyklad"];
            Label1.Text += "<P>Planowany wykad pt. <FONT COLOR='navy'>" + wyklad.Tytul + "</FONT><BR>";
        }

    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Redirect("Formularz.aspx");
    }

    #region Obsuga bazy danych

    private string haslo="";

    private void DodajOsobeDoBazy(out bool czyWyklad,out int wykladID)
    {             
        string nazwaTabeli = "Osoby";

        //przygotowanie polecenia SQL INSERT
        StrukturyDanych.Osoba osoba = (StrukturyDanych.Osoba)Session["osoba"];
        osoba.UsunApostrofy();
        string valuesOsoba = "'" + osoba.Email + "', '" + osoba.Imie + "', '" + osoba.Nazwisko + "', '" +
            osoba.InstytucjaNazwa + "', '" + osoba.InstytucjaAdres1 + "', '" + osoba.InstytucjaAdres2 + "', " + osoba.CzyWyklad;

        StrukturyDanych.Nocleg nocleg = (StrukturyDanych.Nocleg)Session["nocleg"];        
        string valuesNocleg = nocleg.Przyjazd + ", " + nocleg.Wyjazd + ", " + nocleg.CzyNocleg + ", '" + nocleg.TypPokoju + "', " +
            nocleg.OsobaTowarzyszaca + ", " + nocleg.CzyWyzywienie + ", '" + TextBox1.Text + "'";

        string valuesKontrola = "'" + DateTime.Now.ToShortDateString() + "', '" + Request.UserHostAddress + "'";

        //ustalanie losowego hasla
        byte[] hasloBaza=new byte[6];
        new Random().NextBytes(hasloBaza);
        double wsp=255.0/(127.0-33.0);
        foreach (byte b in hasloBaza)
        {
            char znak = (char)(byte)(33 + b / wsp); //ograniczenie liter do standardowego zestawu ASCII
            if (znak == '\'') znak = '#';
            haslo += znak;
        }

        string values = "VALUES(" + valuesOsoba + ", " + valuesNocleg + ", " + valuesKontrola + ", '" + haslo +"')";
        AccessDataSource1.InsertCommand = "INSERT INTO " + nazwaTabeli + "(Email, Imie, Nazwisko, InstytucjaNazwa, InstytucjaAdres1, InstytucjaAdres2, CzyWyklad, Przyjazd, Wyjazd, CzyNocleg, TypPokoju, OsobaTowarzyszaca, CzyWyzywienie, Komentarz, DataZgloszenia, ZdalnyKomputer, Haslo) " + values;

        //dopisanie do bazy danych
        AccessDataSource1.Insert();

        //ustalanie indeksu WykladID
        czyWyklad = osoba.CzyWyklad;
        AccessDataSource1.SelectCommand = "SELECT WykladID FROM "+nazwaTabeli;
        DataRowView rekord=((DataView)AccessDataSource1.Select(DataSourceSelectArguments.Empty))[0];        
        wykladID = (int)rekord["WykladID"];
    }

    private void DodajWykladDoBazy(int wykladID)
    {
        string nazwaTabeli = "Wyklady";

        //przygotowanie polecenia SQL INSERT
        StrukturyDanych.Wyklad wyklad = (StrukturyDanych.Wyklad)Session["wyklad"];
        StrukturyDanych.Osoba osoba = (StrukturyDanych.Osoba)Session["osoba"];
        wyklad.UsunApostrofy();
        string valuesWyklad = wykladID + ", '" + osoba.Email + "', '" + wyklad.Tytul + "', '" +
            wyklad.Mowca + "', '" + wyklad.PozostaliAutorzy + "', '" + wyklad.Streszczenie + "'";

        string values = "VALUES(" + valuesWyklad + ")";
        AccessDataSource2.InsertCommand = "INSERT INTO " + nazwaTabeli + "(WykladID, Email, Tytul, Mowca, PozostaliAutorzy, Streszczenie) " + values;

        //dopisanie do bazy danych        
        AccessDataSource2.Insert();        
    }    

    private void UsunOsobeZBazy()
    {
        string nazwaTabeli = "Osoby";

        //przygotowanie polecenia SQL DELETE
        StrukturyDanych.Osoba osoba = (StrukturyDanych.Osoba)Session["osoba"];
        AccessDataSource1.DeleteCommand = "DELETE FROM " + nazwaTabeli + " WHERE Email='" + osoba.Email + "'";

        //usuniecie z bazy danych
        AccessDataSource1.Delete();
    }

    private void UsunWykladZBazy(int wykladID)
    {
        string nazwaTabeli = "Wyklady";

        //przygotowanie polecenia SQL DELETE
        AccessDataSource2.DeleteCommand = "DELETE FROM " + nazwaTabeli + " WHERE WykladID="+ wykladID;

        //usuniecie z bazy danych
        AccessDataSource2.Delete();
    }


    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            if (Session["modyfikowanieDanych"] != null && (bool)Session["modyfikowanieDanych"])
            {
                UsunOsobeZBazy();
                int staryWykladID = (int)Session["modyfikowanieDanychWykladID"];
                if (staryWykladID > 0) UsunWykladZBazy(staryWykladID);
            }

            bool czyWyklad;
            int wykladID;
            DodajOsobeDoBazy(out czyWyklad, out wykladID);
            if (czyWyklad) DodajWykladDoBazy(wykladID);
            string komunikat = "Nastpujce zgoszenie zostao dodane do bazy danych:<P>" + Label1.Text + "<P>Haso umoliwiajce pniejsz edycj podanych danych: <FONT COLOR=blue>" + haslo + "</FONT><P><FONT COLOR=navy>Do zobaczenia na konferencji!</FONT>";
            Session.Add("komunikat", komunikat);
            Response.Redirect("Koniec.aspx");
        }                
        catch(System.Data.OleDb.OleDbException exc)
        {
            string komunikat = "Wystpi bd przy zapisie zgoszenia do bazy danych (komunikat poniej).<BR>Czy ten adres e-mail nie zosta ju wykorzystany do rejestracji?<P>Komunikat:<BR>" + exc.Message + "<P>Proponuj wrci do edycji zgoszenia i sprbowa usun usterk.";
            komunikat += "<P>Jeeli bd wystpuje mimo poprawienia danych zgoszenia, prosz o kontakt z administratorem witryny <A HREF=mailto:webroot@ptk.pl><FONT COLOR=darkred>webroot@ptk.pl</FONT></A>.";
            Session.Add("komunikat", komunikat);
            Response.Redirect("Blad.aspx");
        }
    }
    #endregion

    private void Blad(object sender, System.EventArgs e)
    {
        string komunikat = "Wystpi nierozpoznany bd!<BR>Proponuj wrci do edycji zgoszenia i sprbowa usun usterk.";
        komunikat+="<P>Jeeli bd wystpuje mimo poprawienia danych zgoszenia, prosz o kontakt z administratorem witryny <A HREF=mailto:webroot@ptk.pl><FONT COLOR=darkred>webroot@ptk.pl</FONT></A>.";
        Session.Add("komunikat",komunikat);
        Response.Redirect("Blad.aspx");
    }

    protected void Button3_Click(object sender, EventArgs e)
    {
        Session.Add("komentarz", null);
        Session.Add("osoba", null);
        Session.Add("wyklad", null);
        Session.Add("nocleg", null);
        Response.Redirect("Formularz.aspx");
    }
    protected void Button4_Click(object sender, EventArgs e)
    {
        Response.Redirect("Index.aspx");
    }
}
